/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.configuration;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.impactdev.impactor.api.configuration.Config;
import net.impactdev.impactor.api.configuration.adapter.ConfigurationAdapter;
import net.impactdev.impactor.api.configuration.key.ConfigKey;
import net.impactdev.impactor.api.configuration.key.SimpleConfigKey;
import net.impactdev.impactor.core.configuration.ImpactorConfigurationAdapter;

public class ImpactorConfig
implements Config {
    private final ConfigurationAdapter adapter;
    private final List<? extends ConfigKey<?>> keys;
    private final ValuesMap values;

    public ImpactorConfig(ConfigurationAdapter adapter, Class<?> provider) {
        this.adapter = adapter;
        this.keys = this.initialise(provider);
        this.values = new ValuesMap(this.keys.size());
        this.init();
    }

    protected void init() {
        this.load(true);
    }

    @Override
    public <T> T get(ConfigKey<T> key) {
        return this.values.get(key);
    }

    protected void load(boolean initial) {
        for (ConfigKey<?> key : this.keys) {
            if (!initial && !key.reloadable()) continue;
            this.values.put(key, key.get(this.adapter));
        }
    }

    @Override
    public void reload() {
        this.adapter.reload();
        this.load(false);
    }

    public List<SimpleConfigKey<?>> initialise(Class<?> keysClass) {
        List keys2 = (List)Arrays.stream(keysClass.getFields()).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> ConfigKey.class.equals(f.getType())).map(f -> {
            try {
                return (SimpleConfigKey)f.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collector.of(ImmutableList.Builder::new, ImmutableList.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableList.Builder::build, new Collector.Characteristics[0]));
        for (int i = 0; i < keys2.size(); ++i) {
            ((SimpleConfigKey)keys2.get(i)).setOrdinal(i);
        }
        return keys2;
    }

    public static class ValuesMap {
        private final Object[] values;

        public ValuesMap(int size) {
            this.values = new Object[size];
        }

        public <T> T get(ConfigKey<T> key) {
            return (T)this.values[key.ordinal()];
        }

        public void put(ConfigKey<?> key, Object value) {
            this.values[key.ordinal()] = value;
        }
    }

    public static final class ImpactorConfigBuilder
    implements Config.ConfigBuilder {
        private Path path;
        private Class<?> provider;
        private Supplier<InputStream> supplier;

        @Override
        public Config.ConfigBuilder provider(Class<?> provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public Config.ConfigBuilder path(Path path) {
            this.path = path;
            return this;
        }

        @Override
        public Config.ConfigBuilder provideIfMissing(Supplier<InputStream> supplier) {
            this.supplier = supplier;
            return this;
        }

        @Override
        public Config build() {
            return new ImpactorConfig(new ImpactorConfigurationAdapter(this.path, this.supplier), this.provider);
        }
    }
}

